import { EMPTY } from '../observable/empty.js';
import { Observable, operate } from '../Observable.js';
export function take(count) {
    return count <= 0
        ?
            () => EMPTY
        : (source) => new Observable((destination) => {
            let seen = 0;
            const operatorSubscriber = operate({
                destination,
                next: (value) => {
                    if (++seen < count) {
                        destination.next(value);
                    }
                    else {
                        operatorSubscriber.unsubscribe();
                        destination.next(value);
                        destination.complete();
                    }
                },
            });
            source.subscribe(operatorSubscriber);
        });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/4f2b772756b8f609e1354b3063de282ccbe7a690/node_modules/rxjs/dist/esm/internal/operators/take.js.map