import { Observable, operate } from '../Observable.js';
export function pairwise() {
    return (source) => new Observable((destination) => {
        let prev;
        let hasPrev = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                const p = prev;
                prev = value;
                hasPrev && destination.next([p, value]);
                hasPrev = true;
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/4f2b772756b8f609e1354b3063de282ccbe7a690/node_modules/rxjs/dist/esm/internal/operators/pairwise.js.map