"use client";

// src/useSuspenseQueries.ts
import { skipToken } from "@tanstack/query-core";
import { useQueries } from "./useQueries.js";
import { defaultThrowOnError } from "./suspense.js";
function useSuspenseQueries(options, queryClient) {
  return useQueries(
    {
      ...options,
      queries: options.queries.map((query) => {
        if (process.env.NODE_ENV !== "production") {
          if (query.queryFn === skipToken) {
            console.error("skipToken is not allowed for useSuspenseQueries");
          }
        }
        return {
          ...query,
          suspense: true,
          throwOnError: defaultThrowOnError,
          enabled: true,
          placeholderData: void 0
        };
      })
    },
    queryClient
  );
}
export {
  useSuspenseQueries
};//# sourceMappingURL=http://go/sourcemap/sourcemaps/4f2b772756b8f609e1354b3063de282ccbe7a690/node_modules/@tanstack/react-query/build/modern/useSuspenseQueries.js.map