"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultServiceName = exports.emptyResource = exports.defaultResource = exports.resourceFromAttributes = exports.serviceInstanceIdDetector = exports.processDetector = exports.osDetector = exports.hostDetector = exports.envDetector = exports.detectResources = void 0;
var detect_resources_1 = require("./detect-resources");
Object.defineProperty(exports, "detectResources", { enumerable: true, get: function () { return detect_resources_1.detectResources; } });
var detectors_1 = require("./detectors");
Object.defineProperty(exports, "envDetector", { enumerable: true, get: function () { return detectors_1.envDetector; } });
Object.defineProperty(exports, "hostDetector", { enumerable: true, get: function () { return detectors_1.hostDetector; } });
Object.defineProperty(exports, "osDetector", { enumerable: true, get: function () { return detectors_1.osDetector; } });
Object.defineProperty(exports, "processDetector", { enumerable: true, get: function () { return detectors_1.processDetector; } });
Object.defineProperty(exports, "serviceInstanceIdDetector", { enumerable: true, get: function () { return detectors_1.serviceInstanceIdDetector; } });
var ResourceImpl_1 = require("./ResourceImpl");
Object.defineProperty(exports, "resourceFromAttributes", { enumerable: true, get: function () { return ResourceImpl_1.resourceFromAttributes; } });
Object.defineProperty(exports, "defaultResource", { enumerable: true, get: function () { return ResourceImpl_1.defaultResource; } });
Object.defineProperty(exports, "emptyResource", { enumerable: true, get: function () { return ResourceImpl_1.emptyResource; } });
var platform_1 = require("./platform");
Object.defineProperty(exports, "defaultServiceName", { enumerable: true, get: function () { return platform_1.defaultServiceName; } });//# sourceMappingURL=http://go/sourcemap/sourcemaps/4f2b772756b8f609e1354b3063de282ccbe7a690/node_modules/@opentelemetry/resources/build/src/index.js.map