"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hostDetector = void 0;
const HostDetectorSync_1 = require("./HostDetectorSync");
/**
 * HostDetector detects the resources related to the host current process is
 * running on. Currently only non-cloud-based attributes are included.
 */
class HostDetector {
    detect(_config) {
        return Promise.resolve(HostDetectorSync_1.hostDetectorSync.detect(_config));
    }
}
exports.hostDetector = new HostDetector();//# sourceMappingURL=http://go/sourcemap/sourcemaps/63fcac100bd5d5749f2a98aa47d65f6eca61db30/node_modules/@opentelemetry/resources/build/src/detectors/platform/node/HostDetector.js.map